/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class CommandParticipant
extends SingleLineCommand2<SequenceDiagram> {
    public CommandParticipant(RegexConcat pattern) {
        super(pattern);
    }

    static IRegex getRegexType() {
        return new RegexOr(new RegexLeaf("TYPE", "(participant|actor|create|boundary|control|entity|database)"), new RegexLeaf("CREATE", "create[%s](participant|actor|boundary|control|entity|database)"));
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram diagram, RegexResult arg) {
        String error;
        boolean create;
        ParticipantType type;
        String code = arg.get("CODE", 0);
        if (diagram.participants().containsKey(code)) {
            diagram.putParticipantInLast(code);
            return CommandExecutionResult.ok();
        }
        Display strings = Display.NULL;
        if (arg.get("FULL", 0) != null) {
            strings = Display.getWithNewlines(arg.get("FULL", 0));
        }
        String typeString1 = arg.get("TYPE", 0);
        String typeCreate1 = arg.get("CREATE", 0);
        if (typeCreate1 != null) {
            type = ParticipantType.valueOf(StringUtils.goUpperCase(typeCreate1));
            create = true;
        } else if (typeString1.equalsIgnoreCase("CREATE")) {
            type = ParticipantType.PARTICIPANT;
            create = true;
        } else {
            type = ParticipantType.valueOf(StringUtils.goUpperCase(typeString1));
            create = false;
        }
        Participant participant = diagram.createNewParticipant(type, code, strings);
        String stereotype = arg.get("STEREO", 0);
        if (stereotype != null) {
            ISkinParam skinParam = diagram.getSkinParam();
            boolean stereotypePositionTop = skinParam.stereotypePositionTop();
            UFont font = skinParam.getFont(FontParam.CIRCLED_CHARACTER, null, false);
            participant.setStereotype(new Stereotype(stereotype, skinParam.getCircledCharacterRadius(), font, diagram.getSkinParam().getIHtmlColorSet()), stereotypePositionTop);
        }
        participant.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            participant.setUrl(url);
        }
        if (create && (error = diagram.activate(participant, LifeEventType.CREATE, null)) != null) {
            return CommandExecutionResult.error(error);
        }
        return CommandExecutionResult.ok();
    }
}

